import "server-only";

import { isObjectEmpty } from "@/app/_utils";
import { loadStaticData,getArticleInfo,getHomeInfo,getMystoryInfo } from "@/app/_libs";
import { applicationUrls } from "@/app/_libs/registerUrl";

import {
  ARTFORMS,
  AWARDS,
  CONTACT_US,
  DESTINATION,
  DISTRICTS,
  E_BROUCHURES,
  EVENT,
  HIGH_RESOLUTION_IMAGES,
  HOW_TO,
  KERALA_AT_A_GLANCE,
  KERALA_FOOD,
  KERALA_STORY,
  MEDIA_ROOM,
  MICROSITES,
  MUNNAR,
  NEWSLETTER,
  OTHERWEBSITES,
  PHOTO_GALLERY,
  PLAN_YOUR_ITINERARY,
  PROFILE,
  SOUVENIR_SHOPS,
  SOUVENIRS,
  TOUR_GUIDES,
  TOUR_PACKAGES,
  TOURISM_INFO_CENTER,
  TOURISM_VISION,
  TOURIST_VISA_ON_ARRIVAL,
  TRAVEL_DESK,
  TRAVEL_TIPS,
  VARKALA,
  VIDEO_GALLERY,
  WHERE_TO_STAY,
} from "@/app/_constants/urlConstant";

import {
  loadArtformJSON,
  loadAwardJSON,
  loadContactUsJSON,
  loadDestinationJSON,
  loadDistrictJson,
  loadEbrouchureJSON,
  loadEventJSON,
  loadImageGalleryJSON,
  loadHowToJSON,
  loadKeralaAtAGlanceJSON,
  loadKeralaFoodJSON,
  loadKeralaStoryJSON,
  loadMediaRoomJSON,
  loadMicroSitesJSON,
  loadMunnarJSON,
  loadNewsLetterJSON,
  loadOtherWebsiteJSON,
  loadPlanYourItineraryJSON,
  loadProfileJSON,
  loadSouvenirShopsJSON,
  loadSouvenirsJSON,
  loadTourGuidesJSON,
  loadTourPackagesJSON,
  loadTourismInfoCenterJSON,
  loadTourismVisionJSON,
  loadTouristVisaOnArrivalJSON,
  loadTravelDeskJSON,
  loadTravelTripsJSON,
  loadVarkalaJSON,
  loadVideoGalleryJSON,
  loadWhereToStayJSON,
} from "./loadMockJson";

const urlLoaders = {
  [ARTFORMS]: loadArtformJSON,
  [AWARDS]: loadAwardJSON,
  [CONTACT_US]: loadContactUsJSON,
  [DESTINATION]: loadDestinationJSON,
  [DISTRICTS]: loadDistrictJson,
  [E_BROUCHURES]: loadEbrouchureJSON,
  [EVENT]: loadEventJSON,
  [HIGH_RESOLUTION_IMAGES]: loadImageGalleryJSON,
  [HOW_TO]: loadHowToJSON,
  [KERALA_AT_A_GLANCE]: loadKeralaAtAGlanceJSON,
  [KERALA_FOOD]: loadKeralaFoodJSON,
  [KERALA_STORY]: loadKeralaStoryJSON,
  [MEDIA_ROOM]: loadMediaRoomJSON,
  [MICROSITES]: loadMicroSitesJSON,
  [MUNNAR]: loadMunnarJSON,
  [NEWSLETTER]: loadNewsLetterJSON,
  [OTHERWEBSITES]: loadOtherWebsiteJSON,
  [PHOTO_GALLERY]: loadImageGalleryJSON,
  [PLAN_YOUR_ITINERARY]: loadPlanYourItineraryJSON,
  [PROFILE]: loadProfileJSON,
  [SOUVENIR_SHOPS]: loadSouvenirShopsJSON,
  [SOUVENIRS]: loadSouvenirsJSON,
  [TOUR_GUIDES]: loadTourGuidesJSON,
  [TOUR_PACKAGES]: loadTourPackagesJSON,
  [TOURISM_INFO_CENTER]: loadTourismInfoCenterJSON,
  [TOURISM_VISION]: loadTourismVisionJSON,
  [TOURIST_VISA_ON_ARRIVAL]: loadTouristVisaOnArrivalJSON,
  [TRAVEL_DESK]: loadTravelDeskJSON,
  [TRAVEL_TIPS]: loadTravelTripsJSON,
  [VARKALA]: loadVarkalaJSON,
  [VIDEO_GALLERY]: loadVideoGalleryJSON,
  [WHERE_TO_STAY]: loadWhereToStayJSON,
};

export async function loadPageData(params,Region,Type,Districts) {
 
if (isObjectEmpty(params)) return await getHomeInfo();

const requestedUrl = params.slug.at(0);
//console.log(requestedUrl);


  if (requestedUrl) 
  {
      if(requestedUrl=='kerala-stories' && params.slug.at(1)){
        return await getMystoryInfo(params.slug.at(1));
      }
      else{
      //console.log("test 0", Districts);
        if(Region != null && Region >= 0 && Type == null && Districts == null  )
        { 
              
            if(params.slug.at(1) != "trending") 
            {
              return await getArticleInfo(params.slug.at(0)+'-search&category='+params.slug.at(1)+'&region=' + Region);
            }
            else
            {
              //console.log(params.slug.toString().replaceAll(',','/'))
              return await getArticleInfo(params.slug.toString().replaceAll(',','/'));
            }
          }

        if(Region != null && Region != 0 && Type != null && Districts == null)
        {  
          //console.log("test 2");
        return await getArticleInfo(params.slug.at(0)+'-search&category='+params.slug.at(1)+'&region=' + Region + '&type=' + Type);
        }

        

        if(Region != null && Region != 0 && Type != null && Districts != null)
        {
          //console.log("test 3");
        return await getArticleInfo(params.slug.at(0)+'-search&category='+params.slug.at(1)+'&region=' + Region + '&type=' + Type + '&district=' + Districts);


        }
        if(Region != null && Region >= 0 && Districts != null)
        {
          //var y = params.slug.at(0)+'-search&category='+params.slug.at(1)+'&region=' + Region + '&district=' + Districts;
          
        //

            if(params.slug.at(1) != "trending") 
            {
              //return await getArticleInfo(params.slug.at(0)+'-search&category='+params.slug.at(1)+'&region=' + Region);
              return await getArticleInfo(params.slug.at(0)+'-search&category='+params.slug.at(1)+'&region=' + Region + '&district=' + Districts);
            }
            else
            {
              //console.log(params.slug.toString().replaceAll(',','/'))
              return await getArticleInfo(params.slug.toString().replaceAll(',','/'));
            }

        }
        else
        {
          return await getArticleInfo(params.slug.toString().replaceAll(',','/'));
        }
      }
  }
 return undefined;
}

